/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-07-09
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CITYSIGNALITEM_H
#define CITYSIGNALITEM_H

#include <QtGui>

#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT CitySignalItem : public QAbstractItemModel
{
  Q_OBJECT
public:
  CitySignalItem( CityScanner * scanner, QObject * parent=0 );
  ~CitySignalItem();

  void refresh() {reset();}

  virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
  virtual QModelIndex parent ( const QModelIndex & index ) const;
  virtual QModelIndex index ( int, int column, const QModelIndex & parent = QModelIndex() ) const;
  virtual Qt::ItemFlags flags ( const QModelIndex & ) const {return Qt::ItemIsSelectable | Qt::ItemIsEditable | Qt::ItemIsEnabled;}
private:
  CityScanner * _scanner;
};

} // namespace GeopsyGui

#endif // CITYSIGNALITEM_H
