/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-09-13
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FILTERPARAMWIDGET_H
#define FILTERPARAMWIDGET_H

#include <GeopsyCore.h>
#include "ui_FilterParamWidget.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT FilterParamWidget : public QWidget, public Ui::FilterParamWidget
{
  Q_OBJECT
public:
  FilterParamWidget(QWidget* parent = 0, Qt::WFlags fl = 0);

  bool getParameters( FilterParameters & param );
  bool loadParameters( QString keyword, QString value );
  void exportParameters( QString & log );
public slots:
  void updateAllFields();
  void on_filterType_activated( int );
  void on_butterBut_toggled( bool );
  void on_taperBut_toggled( bool );
signals:
  void parametersChanged();
};

} // namespace GeopsyGui

#endif // FILTERPARAMWIDGET_H
