/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-10-05
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYGUIOBJECT_H
#define GEOPSYGUIOBJECT_H

#include <QGpGuiTools.h>
#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

class SignalTableItem;

namespace GeopsyGui {

class SubPoolWindow;

class GEOPSYGUI_EXPORT GeopsyGuiObject : public GeopsyCoreBase
{
public:
  virtual void addWindow ( QWidget * ) {}
  virtual void removeWindow ( QWidget * ) {}
  virtual void showWindow ( QWidget * ) {}
  virtual void updateWindowTitle ( QWidget * ) {}
  virtual void addHeaderEditor ( SignalTableItem * ) {}

  virtual SubPoolWindow * newGraphicWindow( const SubSignalPool& ) { return 0; }
  virtual SubPoolWindow * newTableWindow( const SubSignalPool& ) { return 0; }
  virtual SubPoolWindow * newMapWindow( const SubSignalPool& ) { return 0; }

  virtual QStatusBar * statusBar() {return 0;}
  virtual ProgressBar * progressBar() {return 0;}

  virtual SignalFileFormat askLoadFormat(const QString& signalFileName);
  virtual bool askTimeReference(double& t0, QDateTime& timeRef, const QDateTime& timeTrue);
  virtual bool askRD3LogParameter(int& nSamples, double& sampFreq, double& t0);
};

#define geopsyGui static_cast<GeopsyGuiObject *>(geopsyCore)

} // namespace GeopsyGui

#endif // GEOPSYGUIOBJECT_H
