/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-08-04
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LOADFORMAT_H
#define LOADFORMAT_H

#include <GeopsyCore.h>
#include <QGpGuiTools.h>
#include "ui_LoadFormat.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT LoadFormat : public Dialog, private Ui::LoadFormat
{
  Q_OBJECT
public:
  LoadFormat(QWidget * parent=0);

  SignalFileFormat format() const;
  void setSignalFileName(const QString& f);
private:
  QList< QPair<QString, SignalFileFormat> > _formats;
};

} // namespace GeopsyGui

#endif // LOADFORMAT_H
