/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-03-09
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NORMALIZATIONWIDGET_H
#define NORMALIZATIONWIDGET_H

#include <GeopsyCore.h>
#include "ui_NormalizationWidget.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT NormalizationWidget : public QWidget, public Ui::NormalizationWidget
{
  Q_OBJECT
public:
  NormalizationWidget( QWidget * parent=0 );

  void setExternalRange();

  void getParameters( NormalizationParam & param );
  bool loadParameters( QString keyword, QString value );
  void exportParameters( QString & log );
public slots:
  void typeChanged();
signals:
  void parametersChanged();
private:
  NormalizationParam::Type type();
};

} // namespace GeopsyGui

#endif // NORMALIZATIONWIDGET_H
