/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-06-10
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PICKFORMAT_H
#define PICKFORMAT_H

#include <QtGui>

namespace GeopsyGui {

class PickFormat
{
public:
  PickFormat() {}
  PickFormat(const PickFormat& o);

  int count() const { return _formats.count(); }

  bool isVisible(int index) const;
  QColor color(int index) const;

  void setVisible(int index, bool v);
  void setColor(int index, const QColor& c);

  void setVisibles(QStringList v);
  QStringList visibles() const;

  void setColors(QStringList c);
  QStringList colors() const;
private:
  class Format {
  public:
    Format(bool v=false, QColor c=Qt::blue) {visible=v;color=c;}
    Format(const Format& o) {visible=o.visible;color=o.color;}

    bool visible;
    QColor color;
  };

  QVector<Format> _formats;
};

} // namespace GeopsyGui

#endif // PICKFORMAT_H
