/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-09-13
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RINGEDITOR_H
#define RINGEDITOR_H

#include <SciFigs.h>

#include "ui_RingEditor.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

#define RingEditor_MinCol 0
#define RingEditor_MaxCol 1
#define RingEditor_PairsNumCol 2
#define RingEditor_ColorCol 3

class ArrayMap;

class RingEditorDelegate : public QItemDelegate
{
  Q_OBJECT
public:
  RingEditorDelegate(QObject *parent = 0);

  QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
                        const QModelIndex &index) const;
  void setEditorData(QWidget *editor, const QModelIndex &index) const;
  void setModelData(QWidget *editor, QAbstractItemModel *model,
                      const QModelIndex &index) const;
private slots:
  inline void commitSpin();
};

inline void RingEditorDelegate::commitSpin()
{
  TRACE;
  DoubleSpinBox * w=qobject_cast<DoubleSpinBox *>(sender());
  if (w) emit commitData (w);
}

class GEOPSYGUI_EXPORT RingEditor : public QWidget, public Ui::RingEditor
{
  Q_OBJECT
public:
  RingEditor( QWidget* parent = 0, Qt::WFlags fl = 0 );
  ~RingEditor();

  int countPairs( int ringIndex );
  int ringCount();
public slots:
  void setCoArrayGraph( ArrayMap * w );
  void addBut_clicked();
  void removeBut_clicked();
  void on_rings_itemClicked( QTableWidgetItem * item );
  void on_rings_itemChanged( QTableWidgetItem * item );
  void updateCounts();
  void updateGraph();
  void loadBut_clicked();
  void load( QString fileName );
  void saveBut_clicked();
  void optimizeBut_clicked();
private:
  void initRow( int row );
  CircleViewer * _circleLayer;
};

} // namespace GeopsyGui

#endif // RINGEDITOR_H
