/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-08-29
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALGROUPITEM_H
#define SIGNALGROUPITEM_H

#include <GeopsyCore.h>
#include <QtGui>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT SignalGroupItem : public QAbstractItemModel
{
public:
  SignalGroupItem( QObject * parent=0 );
  ~SignalGroupItem() {}

  void setDatabase( SignalDB * db );
  void setFolderOnly( bool f ) { _folderOnly = f; }

  virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QModelIndex parent ( const QModelIndex & index ) const;
  virtual QModelIndex index ( int row, int column, const QModelIndex & parent = QModelIndex() ) const;
  virtual Qt::ItemFlags flags ( const QModelIndex & ) const {return Qt::ItemIsSelectable | Qt::ItemIsEnabled;}

  void setGroupParent( SignalGroup * g, SignalGroup * parent );

  void getSelection( SubSignalPool& sel, const QItemSelectionModel& sm, const QModelIndex& parent = QModelIndex() );
  void getSelection( QList<SignalGroup *>& sel, const QItemSelectionModel& sm, const QModelIndex& parent = QModelIndex() );
  static SignalGroup * group( const QModelIndex & index );
  QModelIndex index( SignalGroup * g );
  void removeChildren();
protected:
  void removeChildren( SignalGroup * g );
  SignalDB * _db;
  bool _folderOnly;
};


} // namespace GeopsyGui

#endif // SIGNALGROUPITEM_H
