/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-11-10
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SUBPOOLWINDOW_H
#define SUBPOOLWINDOW_H

#include <QtGui>
#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class ToolBase;

class GEOPSYGUI_EXPORT SubPoolWindow: public QWidget
{
  Q_OBJECT
public:
  SubPoolWindow( QWidget* parent = 0 );
  virtual ~SubPoolWindow();

  void setSubPool( const SubSignalPool& subPool );
  SubSignalPool& subPool() { return _subPool; }
  const SubSignalPool& subPool() const { return _subPool; }

  // Toolboxes
  virtual void setTool( ToolBase * tw ) {_tool = tw;}
  ToolBase * tool() { return _tool;}

  // Function to redefine in child classes to update view after SubPool changes
  virtual void setWindowTitle( QString title );
  virtual void signalsUpdate();
  // Function to redefine in child class to make fft and attached updates
  virtual void fastFourierTransform( DoubleSignal::SignalType st ) = 0;

  void lock();
  void unlock();
  bool isLocked();

  // Waveform processing
  SignalProcessScript * signalProcess();
  bool run( const QString& script );
public slots:
  void addSignals( const SubSignalPool& sel );
  void addFile( QString fileName );
  void addSignal( int id );
  void addSignal( SubPoolWindow * viewer, int index );
  virtual void subPoolUpdate() = 0;
  virtual void refreshSignal( Signal * sig );
protected:
  virtual void closeEvent ( QCloseEvent * e );
signals:
  void signalTypeChanged( DoubleSignal::SignalType );
  void aboutToClose();
private:
  SubSignalPool _subPool;
  SignalProcessScript * _signalProcess;
  // Toolboxes
  ToolBase * _tool;
  bool _locked;
};

} // namespace GeopsyGui

#endif // SUBPOOLWINDOW_H
