/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-09-13
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMELIMITSSELECTOR_H
#define TIMELIMITSSELECTOR_H

#include <GeopsyCore.h>

#include "ui_TimeLimitsSelector.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT TimeLimitsSelector : public QWidget, private Ui::TimeLimitsSelector
{
  Q_OBJECT;
public:
  TimeLimitsSelector( QWidget* parent = 0, Qt::WFlags fl = 0 );

  void removeUseFirstOnly();
  void setPicks( SubSignalPool * subPool );
  bool loadParameters( QString keyword, QString value, const QString& prefix = QString::null );

  void getParameters( RelativeTimeRange & param ) const;
  void setParameters( const RelativeTimeRange & param );
  void exportParameters( QString & log, const QString& prefix = QString::null );
public slots:
  void setPicks( Signal * sig );
  void updateAllFields();
  void on_fromType_activated( int );
  void on_toType_activated( int );
signals:
  void parametersChanged();
private:
  TimeRange _totalRange;
  Signal * _firstSignal;
};

} // namespace GeopsyGui

#endif // TIMELIMITSSELECTOR_H
