/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-28
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEWINDOW_H
#define TIMEWINDOW_H

#include <QtGui>

#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT TimeWindow : public TimeRange, public XMLClass
  {
  public:
    TimeWindow(double start=0.0, double end=0.0, const QColor& c=Qt::black)
      : TimeRange(start, end), XMLClass() {_color=c;}
    TimeWindow(const TimeWindow& o)
      : TimeRange(o), XMLClass() {_color=o._color;}
    virtual ~TimeWindow() {}

    virtual const QString& xml_tagName() const {return xmlTimeWindowTag;}
    static const QString xmlTimeWindowTag;

    const QColor& color() const {return _color;}
    void setColor(const QColor& c) {_color=c;}

    virtual void xml_attributes( XML_ATTRIBUTES_ARGS ) const;
    virtual bool xml_setAttributes( XML_SETATTRIBUTES_ARGS );
  private:
    QColor _color;
  };

} // namespace GeopsyGui

#endif // TIMEWINDOW_H
