/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-04-21
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEWINDOWLAYER_H
#define TIMEWINDOWLAYER_H

#include <SciFigs.h>
#include <GeopsyCore.h>

#include "TimeWindowList.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class SignalLayer;

class GEOPSYGUI_EXPORT TimeWindowLayer : public GraphContentLayer
{
  Q_OBJECT
  Q_PROPERTY( double size READ size WRITE setSize SCRIPTABLE true )
  Q_PROPERTY( bool showColors READ showColors WRITE setShowColors SCRIPTABLE true )
public:
  TimeWindowLayer(AxisWindow * parent=0);
  TimeWindowLayer(SignalLayer * sig);
  virtual ~TimeWindowLayer();

  virtual const QString& xml_tagName() const {return xmlTimeWindowLayerTag;}
  static const QString xmlTimeWindowLayerTag;

  void addTimeWindows(const SubSignalPool& subPool, TimeWindowList * l);
  void addTimeWindows(Signal * sig, TimeWindowList * l);
  void clearTimeWindows();

  virtual Rect boundingRect() const;

  double size() const {return _size;}
  void setSize( double s );

  bool showColors() const {return _showColors;}
  void setShowColors(bool b);
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual void xml_layerPolish(XML_POLISH_ARGS);
private:
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;

  inline void paintTimeWindows(const GraphContentOptions& gc, QPainter& p,
                               const TimeWindowList& windows, Signal * sig, int iSig) const;

  SignalLayer * _sig;
  QMap<Signal *, TimeWindowList *> _windows;

  double _size;
  bool _showColors;
  bool _windowOwner;

  struct XMLTimeWindowList
  {
    QMap<int, TimeWindowList *> _windows;
    QString _signalLayerName;
  };
  XMLTimeWindowList * _xmlWindows;
};

} // namespace GeopsyGui

#endif // TIMEWINDOWLAYER_H
