/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-28
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEWINDOWLIST_H
#define TIMEWINDOWLIST_H

#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"
#include "TimeWindow.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT TimeWindowList: public TimeRangeList, public XMLClass
  {
  public:
    TimeWindowList()
      : TimeRangeList(), XMLClass(), _defaultColor(QColor(200, 255, 193)) {}
    TimeWindowList(const TimeWindowList& o, int firstIndex)
      : TimeRangeList(o, firstIndex), XMLClass(), _defaultColor(QColor(200, 255, 193)) {}
    ~TimeWindowList();

    virtual const QString& xml_tagName() const {return xmlTimeWindowListTag;}
    static const QString xmlTimeWindowListTag;

    void setDefaultColor(const QColor& c) {_defaultColor=c;}
    const QColor& defaultColor() const {return _defaultColor;}
    void resetColors();

    void addOne(const TimeRange& r) {TimeRangeList::addOne(r);}
    TimeWindow& addOne() {return static_cast<TimeWindow&>(TimeRangeList::addOne());}

    const TimeWindow& at(int index) const {return static_cast<const TimeWindow&>(TimeRangeList::at(index));}
    TimeWindow& at(int index) {return static_cast<TimeWindow&>(TimeRangeList::at(index));}
  protected:
    virtual TimeRange * newTimeRange(double start, double end) {return new TimeWindow(start, end, _defaultColor);}
    virtual TimeRange * cloneTimeRange(TimeRange * r) {return new TimeWindow(*static_cast<TimeWindow *>(r));}
    virtual void deleteTimeRange(TimeRange * r) {delete static_cast<TimeWindow *>(r);}

    virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    virtual XMLMember xml_member(XML_MEMBER_ARGS);
    virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  private:
    QColor _defaultColor;
  };

} // namespace GeopsyGui

#endif // TIMEWINDOWLIST_H
