/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-09-02
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TOOLBASE_H
#define TOOLBASE_H

#include <QtGui>
#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class SignalLayer;
class PickLayer;
class TimeWindowLayer;
class SubPoolWindow;
class ToolInterface;

class GEOPSYGUI_EXPORT ToolBase : public QWidget
{
  Q_OBJECT
public:
  ToolBase( QWidget * parent, int nChildren );
  ~ToolBase();

  void setSubPoolParent( SubPoolWindow * subPoolParent ) {_subPoolParent = subPoolParent;}
  void setLayers( SignalLayer * sl, PickLayer * pl, TimeWindowLayer * wl );
  virtual bool initStations( SubSignalPool * ) { return false;}
  virtual void closeChildren();
  virtual void restoreFields();
  virtual void refreshSignal( Signal * ) {}
  virtual void updateAllFields() {}
  virtual void paintTimeWindows( QPainter& , Signal* , double , int , int ,
                                 double , double ) {}
  virtual void setParameters(int&, char **);
  virtual void outputResults(int&, char **) {}
  virtual void start() {}
  virtual void waitFinished() {}
  void setWindowTitle( QString t );

  void setLibSlot( ToolInterface * lib, int slot ) {_lib = lib; _libSlot = slot;}
  bool isLibSlot( ToolInterface * lib, int slot ) { return _lib == lib && _libSlot == slot;}

  SignalLayer * signalLayer() const { return _signalLayer; }
  TimeWindowLayer * timeWindowLayer() const { return _timeWindowLayer; }
  PickLayer * pickLayer() const { return _pickLayer; }
public slots:
  void windowActivated( QWidget * w );
  void loadLogParameters( QString fileName = QString::null );
  void saveLogParameters( QString fileName = QString::null );
  virtual void showTool();
signals:
  void updateSubPool();
protected:
  virtual void contextMenuEvent( QContextMenuEvent *e );
  virtual bool setLogParameters( QString&, QString& ) { return false;}
  virtual QString logParameters() const { return QString::null; }
  bool subPoolLocked();
  void lockSubPool();
  void unlockSubPool();
protected:
  SubSignalPool * _subPool;
  int _nChildren;
  QWidget ** _childrenList;
private:
  SubPoolWindow * _subPoolParent;
  SignalLayer * _signalLayer;
  TimeWindowLayer * _timeWindowLayer;
  PickLayer * _pickLayer;
  ToolInterface * _lib;
  int _libSlot;
};

inline void ToolBase::setLayers( SignalLayer * sl, PickLayer * pl, TimeWindowLayer * wl )
{
  TRACE;
  _signalLayer = sl;
  _timeWindowLayer=wl;
  _pickLayer = pl;
}

} // namespace GeopsyGui

#endif // TOOLBASE_H
