/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-11-05
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TOOLINTERFACE_H
#define TOOLINTERFACE_H

#include <QtGui>
#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"
#include "GeopsyGuiVersion.h"
#include "GeopsyGuiInstallPath.h"

namespace GeopsyGui {

class ToolBase;

class GEOPSYGUI_EXPORT ToolInterface : public QObject
{
  Q_OBJECT
public:
  ToolInterface(QObject * parent=0) : QObject(parent) {}
  virtual ~ToolInterface() {}

  virtual QString tag() const = 0;
  virtual QString title() const = 0;
  virtual QString description() const;

  virtual void createToolActions(QObject * toolFactory) = 0;
  virtual QList<QAction *> createImportActions(QObject * /* parent */) const {return QList<QAction *>();}
  virtual ToolBase * createTool(int id, QWidget * wsParent) const = 0;

  virtual void addPreferenceTab(QTabWidget * parent);
  virtual void setPreferences();

  virtual int exec( SubSignalPool * subPool, int slot, int argc, char ** argv);
  virtual void setHelp( ApplicationHelp * h );

  int slotCount() const {return _actions.count();}
  int slotOf(QAction * a) {return _actions.indexOf(a);}
  QAction * action(int slot) const {return _actions[slot];}
  QString slotText(int id) {return _actions[id]->text();}
  void addActions(QWidget * w) const;

  bool isValid() const;
  virtual const char * interfaceVersion() const = 0;
protected:
  void addAction(QAction * a) {_actions << a;}
private:
  QVector<QAction *> _actions;
};

class GEOPSYGUI_EXPORT ToolSeparator : public ToolInterface
{
  TRANSLATIONS("ToolSeparator")
public:
  ToolSeparator(QObject * parent=0) : ToolInterface(parent) {}

  virtual QString tag() const {return "separator";}
  virtual QString title() const {return tr("--- Separator ---");}

  virtual void createToolActions(QObject * toolFactory);
  QList<QAction *> createImportActions(QObject * parent) const;
  virtual ToolBase * createTool(int , QWidget *) const {return 0;}

  virtual const char * interfaceVersion() const { return GEOPSYGUI_VERSION; }
};

} // namespace GeopsyGui

Q_DECLARE_INTERFACE( GeopsyGui::ToolInterface, "org.geopsy.toolInterface/1.0" );

#endif // TOOLINTERFACE_H
