/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-09-13
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef WINDOWINGPARAMWIDGET_H
#define WINDOWINGPARAMWIDGET_H

#include <QtGui>
#include <GeopsyCore.h>
#include "ui_WindowingParamWidget.h"
#include "GeopsyGuiDLLExport.h"
#include "FilterParamWidget.h"

namespace GeopsyGui {

class FilterParamWidget;

class GEOPSYGUI_EXPORT WindowingParamWidget : public QWidget, private Ui::WindowingParamWidget
{
  Q_OBJECT
public:
  WindowingParamWidget( QWidget* parent = 0, Qt::WFlags fl = 0 );

  void removeFilterOption();
  void removeFreqDepOption();

  void clear();
  void addComponent( QString name );
  void addStation( QString name );

  void setLength( WindowingParameters::LengthType t, double min, double max = 0.0 );
  void getParameters( WindowingParameters & param );

  bool loadParameters( QString keyword, QString value );
  void exportParameters( QString & log );
public slots:
  void updateAllFields();
private slots:
  void setRawEnabled( bool b );
  void setFilteredEnabled( bool b );

  void on_isRaw_toggled( );
  void on_isFiltered_toggled( );
  void on_isRawTab_toggled( );
  void on_isFilteredTab_toggled( );
  void on_isTolerance_toggled( );
  void on_isOverlap_toggled( );
  void on_isBadSample_toggled( );
  void on_windowLengthType_activated( int );
signals:
  void parametersChanged();
private:
  int _nComponents;
};

} // namespace GeopsyGui

#endif // WINDOWINGPARAMWIDGET_H
