/***************************************************************************
**
**  This file is part of GeopsySLink.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-04-24
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEEDLINKSERVER_H
#define SEEDLINKSERVER_H

#include <QGpCoreTools.h>
#include <GeopsyCore.h>
#include "GeopsySLinkDLLExport.h"

namespace GeopsySLink {

class SeedLinkStation;

class GEOPSYSLINK_EXPORT SeedLinkServer : public XMLClass, private QList<SeedLinkStation *>
{
public:
  ~SeedLinkServer();

  virtual const QString& xml_tagName() const {return xmlSeedLinkServerTag;}
  static const QString xmlSeedLinkServerTag;

  virtual void xml_attributes( XML_ATTRIBUTES_ARGS ) const;
  virtual bool xml_setAttributes( XML_SETATTRIBUTES_ARGS );

  QString software() const { return _software; }
  QString organization() const { return _organization; }
  QString beginTime() const { return _beginTime; }

  void addStation(SeedLinkStation * station) {append(station);}
  int indexOf( SeedLinkStation * station ) const { return QList<SeedLinkStation *>::indexOf(station); }
  QList<int> indexOf( QRegExp networkStation ) const;
  const SeedLinkStation * at(int index) const {return QList<SeedLinkStation *>::at(index);}
  int count() const {return QList<SeedLinkStation *>::count();}
  void clear();

  SubSignalPool allSignals() const;
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual void xml_polish(XML_POLISH_ARGS);
private:
  QString _software;
  QString _organization;
  QString _beginTime;
};


} // namespace GeopsySLink

#endif // SEEDLINKSERVER_H
