/***************************************************************************
**
**  This file is part of GeopsySLink.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-04-24
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEEDLINKSTREAM_H
#define SEEDLINKSTREAM_H

#include <GeopsyCore.h>

#include "GeopsySLinkDLLExport.h"

namespace GeopsySLink {

class SeedLinkStation;

class GEOPSYSLINK_EXPORT SeedLinkStream : public XMLClass
{
  TRANSLATIONS("SeedLinkStream")
public:
  SeedLinkStream( SeedLinkStation * station );

  enum BufferType { Unlimited, CreateNew, Rotate };

  virtual const QString& xml_tagName() const {return xmlSeedLinkStreamTag;}
  static const QString xmlSeedLinkStreamTag;

  SeedLinkStation * station() const { return _station; }

  QByteArray tag() const { return _tag; }
  void setTag();

  virtual void xml_attributes( XML_ATTRIBUTES_ARGS ) const;
  virtual bool xml_setAttributes( XML_SETATTRIBUTES_ARGS );

  QString location() const { return _location; }

  QString seedName() const { return _seedName; }
  void setSeedName(QString n) {_seedName=n;}

  QString type() const { return _type; }
  QString beginTime() const { return _beginTime; }
  QString endTime() const { return _endTime; }
  int beginRecNo() const { return _beginRecNo; }
  int endRecNo() const { return _endRecNo; }
  bool gapCheck() const { return _gapCheck; }
  int gapThreshold() const { return _gapThreshold; }

  DynamicSignal * signal() const { return _signal; }
  void initSignal( double t0, double samplingFrequency );
  void detachSignal() { _signal = 0; }
  double localTime( double t ) const;
  void set( double t, int * samples, int nSamples, BufferType bt, double maxTime = 0.0 );

  bool listening() const { return _listening; }
  bool setListening( bool l ) { return _listening = l; }
private:
  void createSignal();

  SeedLinkStation * _station;

  QString _location;
  QString _seedName;
  QString _type;
  QString _beginTime;
  QString _endTime;
  int _beginRecNo;
  int _endRecNo;
  bool _gapCheck;
  int _gapThreshold;
  QByteArray _tag;

  DynamicSignal * _signal;
  bool _listening;
};

} // namespace GeopsySLink

#endif // SEEDLINKSTREAM_H
