/***************************************************************************
**
**  This file is part of GeopsySLinkGui.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-04-30
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEEDLINKLOADER_H
#define SEEDLINKLOADER_H

#include <GeopsySLink.h>

#include "ui_SeedLinkLoader.h"
#include "GeopsySLinkGuiDLLExport.h"

namespace GeopsySLinkGui {

class GEOPSYSLINKGUI_EXPORT SeedLinkLoader : public QWidget, private Ui::SeedLinkLoader
{
  Q_OBJECT
public:
  SeedLinkLoader( QWidget * parent=0 );
  ~SeedLinkLoader();

  void removeOptions();
  void removeView();

  void setServer( QString serverAddress, int serverPort );
  void selectStreams( QString selection );

  void setFromTime( QDateTime f ) { _seedLink->setFromTime( f ); }
  void setBufferType( SeedLinkStream::BufferType bt ) { _seedLink->setBufferType( bt ); }
  void setMaximumDuration( double d ) { _seedLink->setMaximumDuration(d); }
private slots:
  void on_selectBut_clicked();
  void on_connectBut_clicked();
  void on_startBut_clicked();
  void on_stopBut_clicked();
  void on_viewBut_clicked();
  void on_optionsBut_clicked();
  void streamInfoAvailable();
  void seedLinkError( SeedLink::Error e);
  void showContextMenu( const QPoint & pos );
  void monitorDataChange( Signal * sig, const TimeRange& tw );
signals:
  void started();
  void stopped();
  void dataChanged( Signal * sig, TimeRange tw );
private:
  void setStreamsEnabled( bool b );
  bool isAnySelected();

  SeedLink * _seedLink;
  QString _streamSelection;
};

} // namespace GeopsySLinkGui

#endif // SEEDLINKLOADER_H
