/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-25
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ADDRESS_H
#define ADDRESS_H

#include <string>
#include <arpa/inet.h>

namespace GpCoreTools {

class Address
{
public:
  Address() {_value=0;}
  Address(in_addr_t a) {_value=a;}
  Address(int index, const Address& subnet);
  Address(const Address& o) {_value=o._value;}

  Address operator=(const Address& o) {_value=o._value; return *this;}
  Address operator&(const Address& o) const {return _value & o._value;}
  bool operator==(const Address& o) const {return _value==o._value;}
  bool operator!=(const Address& o) const {return _value!=o._value;}
  bool operator<(const Address& o) const {return _value<o._value;}
  bool operator>(const Address& o) const {return _value>o._value;}

  bool isValid() const {return _value!=0;}
  Address subnet() const {return operator&(_mask);}
  in_addr_t value() const {return _value;}
  inline std::string toString() const;
  void fromString(const char * a) {_value=inet_addr(a);}
  int index() const;

  static const Address& me() {return _me;}
  static void identifyMe(const char * interface);
  static void setMaskSize(int m);
  static const Address& mask() {return _mask;}
  static int maskSize() {return _maskSize;}
private:
  in_addr_t _value;
  static Address _mask;
  static int _maskSize;
  static Address _me;
};

inline std::string Address::toString() const
{
  in_addr a;
  a.s_addr=_value;
  return inet_ntoa(a);
}

} // namespace GpCoreTools

#endif // ADDRESS_H
