/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-07-01
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef APPLICATIONHELP_H
#define APPLICATIONHELP_H

#include <list>
#include <string>

#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT ApplicationHelp
{
public:
  ApplicationHelp();
  ~ApplicationHelp();

  void exec( const char * group = 0 );

  void addGroup(const char * title, const char * section);
  void addOption(const char * option, const char * comments);
  void setOptionSummary(const char * optionSummary) { _optionSummary = optionSummary; }
  void setComments(const char * comments) { _comments = comments; }
  void setSeeAlso(const char * seeAlso) { _seeAlso = seeAlso; }
  void addExample(const char * command, const char * comments);

  std::list<const char *> sections();
  static void print(std::string p, const std::string& linePrefix="", int indent=0);
  static std::string getLine(std::string& text, int maxLength, bool * newLine=0);
private:
  struct Option {
    std::string option;
    std::string comments;
  };
  struct OptionGroup {
    std::list<Option> options;
    std::string title;
    std::string section;
  };
  struct Example {
    std::string command;
    std::string comments;
  };
  std::list<OptionGroup> _options;
  std::list<Example> _examples;
  std::string _optionSummary;
  std::string _comments;
  std::string _seeAlso;

  void print(const OptionGroup& g);
  void execHtml();
  static std::string getCustomIndent( std::string& text );
};

} // namespace GpCoreTools

#endif // APPLICATIONHELP_H
