/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-21
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef AVERAGE_H
#define AVERAGE_H

#include <vector>

#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT Average
{
public:
  Average();

  void add(double v) {_values.push_back(v);}
  void reset() {_values.clear();}

  void calculate();
  int badValue();
  void remove(int i);

  int count() const {return _values.size();}
  double mean() const {return _mean;}
  double stddev() const {return _stddev;}
private:
  std::vector<double> _values;
  double _mean;
  double _stddev;
};

} // namespace GpCoreTools

#endif // AVERAGE_H
