/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-07-01
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COREAPPLICATION_H
#define COREAPPLICATION_H

#include <string>
#include <errno.h>

#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class ApplicationHelp;

class GPCORETOOLS_EXPORT CoreApplication
{
public:
  CoreApplication(int & argc, char ** argv, ApplicationHelp * ( *help ) (), bool reportBugs = true);
  ~CoreApplication();

  static std::string version();
  static std::string version(const char * item);
  static std::string authors();
  static void exit(int exitCode);

  static bool checkOptionArg(int& i, int argc, char ** argv, bool mandatory = true);
  void showHelp(int& i, int argc, char ** argv, ApplicationHelp * ( *help ) ());

  static CoreApplication * instance() { return _self; }

  static std::string getStdin();
  static std::string backTrace();
  static std::string backTraceBug();
  static void osSignal( int sigNum );
  int terminalRows() const;
  int terminalCols() const;
  const char * applicationName() const { return _applicationName.data();}
  static void initInternalDebugger(bool reportBugs);
private:
  void terminalSize() const;
  void reportBug();
  void setHelp(ApplicationHelp * h);

  static CoreApplication * _self;
  std::string _applicationName;
  mutable int _terminalCols, _terminalRows;
};

} // namespace GpCoreTools

#endif // COREAPPLICATION_H
