/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-06-28
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DYNAMICBUFFER_H
#define DYNAMICBUFFER_H

#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT DynamicBuffer
{
public:
  DynamicBuffer(int fd);
  virtual ~DynamicBuffer();

  void setFd(int fd) {_fd=fd;}

  int read();
  int sendPartial(const char * bytes, int byteCount) const {
    return ::send(_fd, bytes, byteCount, MSG_MORE);
  }
  int sendPartialNoGateway(const char * bytes, int byteCount) const {
    return ::send(_fd, bytes, byteCount, MSG_DONTROUTE | MSG_MORE);
  }
  int send(const char * bytes, int byteCount) const {
    return ::write(_fd, bytes, byteCount);
  }
  int sendNoGateway(const char * bytes, int byteCount) const {
    return ::send(_fd, bytes, byteCount, MSG_DONTROUTE);
  }
protected:
  virtual int bytesAvailable(const char * bytes, int byteCount)=0;
private:
  int _fd;
  int _bufferCapacity;
  int _bufferIn;
  int _bufferOut;
  char * _buffer;
};

} // namespace GpCoreTools

#endif // DYNAMICBUFFER_H
