/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-19
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef EVENTLOOP_H
#define EVENTLOOP_H

#include <vector>
#include <list>
#include <queue>

#include "GpCoreToolsDLLExport.h"
#include "Timer.h"

namespace GpCoreTools {

class Event;
class Stream;
class EventStream;

class GPCORETOOLS_EXPORT EventLoop
{
public:
  EventLoop();
  ~EventLoop();

  void addEvent(Event * event) {_events.push(event);}
  void addStream(Stream * s) {_streams.push_back(s);}
  Timer::QueueItem * addTimer(Timer * t);
  void terminate();
  void exec();

  static EventLoop * instance() {return _self;}
private:
  void addTimer(Timer::QueueItem * tq);

  std::vector<Stream *> _streams;
  std::list<Timer::QueueItem *> _timers;
  std::queue<Event *> _events;
  EventStream * _eventStream;
  bool _terminate;
  static EventLoop * _self;
};

} // namespace GpCoreTools

#endif // EVENTLOOP_H
