/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-06-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef INFINITELOOP_H
#define INFINITELOOP_H

#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT InfiniteLoop
{
public:
  InfiniteLoop();
  ~InfiniteLoop();

  inline void start();
  inline void stop();
  void wait();
  inline bool isRunning() const;
protected:
  inline bool isTerminated() const;
  inline void setTerminated();
private:
  enum State {NotRunning, Running, Terminate};
  volatile State _state;
};

inline void InfiniteLoop::start()
{
  _state=Running;
}

inline void InfiniteLoop::stop()
{
  if(_state==Running) {
    _state=Terminate;
  }
}

inline bool InfiniteLoop::isRunning() const
{
  return _state!=NotRunning;
}

inline bool InfiniteLoop::isTerminated() const
{
  return _state==Terminate;
}

inline void InfiniteLoop::setTerminated()
{
  _state=NotRunning;
}

} // namespace GpCoreTools

#endif // INFINITELOOP_H
