/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-24
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEDS_H
#define LEDS_H

#include "Timer.h"
#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT Leds
{
public:
  Leds();
  ~Leds() {_self=0;}

  static void timer(int index, int msecOn, int msecOff);
  static void power(int index, bool on);
  static void flash(int index, int msec, bool on);
private:
  bool test(int index);
  void setTrigger(int index, const char * type);
  void powerInternal(int index, bool on);
  void setDelayOn(int index, int msec);
  void setDelayOff(int index, int msec);

  class LedTimer: public Timer
  {
  public:
    virtual bool exec();
    int _index;
    bool _on;
  };

  static Leds * _self;
  LedTimer _timer[3];
};

} // namespace GpCoreTools

#endif // LEDS_H
