/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-06-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PTHREAD_H
#define PTHREAD_H

#include <map>
#include <list>
#include <vector>

#include "InfiniteLoop.h"
#include "Trace.h"
#include "TraceBug.h"
#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT PThread : public InfiniteLoop
{
public:
  virtual ~PThread() {}

  void start();
  void stop();
  pthread_t id() const {return _id;}
  static PThread * currentThread();
  static void lockThreads() {pthread_mutex_lock(&_threadsMutex);}
  static void unlockThreads() {pthread_mutex_unlock(&_threadsMutex);}

  static std::list< std::vector<TraceBug *> * > bugStacks();
  std::vector<TraceBug  *> * bugStack() { return &_bugStack; }
#ifdef TRACE_ENABLED
  static std::list< std::vector<const TraceStamp *> * > stacks();
  std::vector<const TraceStamp *> * stack() { return &_stack; }
#endif
protected:
  virtual void run()=0;
private:
  static void * run(void * arg);
  static void terminate(int id);

  pthread_t _id;
  static pthread_mutex_t _threadsMutex;
  static std::map<pthread_t, PThread *> _threads;

#ifdef TRACE_ENABLED
  std::vector<const TraceStamp *> _stack;
#endif
  std::vector<TraceBug *> _bugStack;

};

} // namespace GpCoreTools

#endif // PTHREAD_H
