/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-07-01
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PACKAGEINFO_H
#define PACKAGEINFO_H

#include <string>
#include <list>

#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT PackageInfo
{
public:
  PackageInfo( const char * package,
                      const char * binDir,
                      const char * libDir,
                      const char * includeDir,
                      const char * shareDir,
                      const char * version,
                      const char * versionTime,
                      const char * versionType,
                      const char * distribtion,
                      const char * authors);
  PackageInfo( const PackageInfo& o );

  const std::string & package() const {return _package;}
  const std::string & binDir() const {return _binDir;}
  const std::string & libDir() const {return _libDir;}
  const std::string & includeDir() const {return _includeDir;}
  const std::string & shareDir() const {return _shareDir;}
#ifdef Q_WS_WIN
  const std::string & dllDir() const { return binDir(); }
#else
  const std::string & dllDir() const { return libDir(); }
#endif
  const std::string & version() const {return _version;}
  const std::string & versionTime() const {return _versionTime;}
  const std::string & versionType() const {return _versionType;}
  const std::string & distribution() const {return _distribution;}
  const std::string & authors() const {return _authors;}

  static std::string getInstallDir( std::string organization, std::string package, std::string dir, std::string defaultDir);
  static const PackageInfo * package( std::string package);
  static std::list<PackageInfo> * list();
private:
  std::string _package;
  std::string _binDir;
  std::string _libDir;
  std::string _includeDir;
  std::string _shareDir;
  std::string _version;
  std::string _versionTime;
  std::string _versionType;
  std::string _distribution;
  std::string _authors;

  static std::list<PackageInfo> * _list;
};

#define PACKAGE_INFO(package, PACKAGE) \
  class package##InfoInit \
  { \
  public: \
    package##InfoInit() { \
      PackageInfo::list()->push_back( PackageInfo( # package, \
            PackageInfo::getInstallDir("geopsy", # package, "binDir", PACKAGE##_BINDIR).data(), \
            PackageInfo::getInstallDir("geopsy", # package, "libDir", PACKAGE##_LIBDIR).data(), \
            PackageInfo::getInstallDir("geopsy", # package, "includeDir", PACKAGE##_INCDIR).data(), \
            PackageInfo::getInstallDir("geopsy", # package, "shareDir", PACKAGE##_SHAREDIR).data(), \
            PACKAGE##_VERSION, \
            PACKAGE##_VERSION_TIME, \
            PACKAGE##_VERSION_TYPE, \
            PACKAGE##_DISTRIBUTION, \
            PACKAGE##_AUTHORS) ); \
    } \
  }; \
  package##InfoInit autoInit##package;


} // namespace GpCoreTools

#endif // PACKAGEINFO_H
