/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-06-26
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SERIAL_H
#define SERIAL_H

#include <unistd.h>

#include "DynamicBuffer.h"
#include "GpCoreToolsDLLExport.h"

struct termios;

namespace GpCoreTools {

class GPCORETOOLS_EXPORT Serial
{
public:
  Serial(DynamicBuffer * buffer);
  virtual ~Serial();

  bool open(const char * pathName);
  void init();
  void exec();

  inline void write(const char * buf, ssize_t byteCount);
  DynamicBuffer * buffer() const {return _buffer;}
private:
  static int outputSpeed(termios * t);

  int _fd;
  DynamicBuffer * _buffer;
};

inline void Serial::write(const char * buf, ssize_t byteCount)
{
  ::write(_fd, buf, byteCount);
}

} // namespace GpCoreTools

#endif // SERIAL_H
