/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-19
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STREAM_H
#define STREAM_H

#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT Stream
{
public:
  Stream();
  virtual ~Stream();

  int fileDescriptor() const {return _fileDescriptor;}
  void close();
  bool isActive() const {return _fileDescriptor>0;}

  virtual short eventTypes()=0;
  virtual void event(short type)=0;

  void setParent(Stream * parent) {_parent=parent;}
protected:
  virtual void childDeleted(Stream *) {}
  void setFileDescriptor(int fd) {_fileDescriptor=fd;}
private:
  Stream * _parent;

  int _fileDescriptor;
};

} // namespace GpCoreTools

#endif // STREAM_H
