/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-19
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TCPCLIENTSTREAM_H
#define TCPCLIENTSTREAM_H

#include <poll.h>
#include <unistd.h>
#include <stdlib.h>

#include "Stream.h"
#include "Address.h"
#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class DynamicBuffer;

class GPCORETOOLS_EXPORT TcpClientStream : public Stream
{
public:
  TcpClientStream(int fileDescriptor, const Address& peer);
  TcpClientStream(const Address& peer);
  virtual ~TcpClientStream();

  virtual bool connect(uint16_t port);

  virtual short eventTypes() {return POLLIN | POLLRDHUP;}
  virtual void event(short type);
  virtual void hungup() {}

  const Address& peer() const {return _peer;}
  DynamicBuffer * buffer() const {return _buffer;}

  int writePartial(const char * bytes, int byteCount) const {
    return ::send(fileDescriptor(), bytes, byteCount, MSG_MORE);
  }
  int writePartialNoGateway(const char * bytes, int byteCount) const {
    return ::send(fileDescriptor(), bytes, byteCount, MSG_DONTROUTE | MSG_MORE);
  }
  int write(const char * bytes, int byteCount) const {
    return ::write(fileDescriptor(), bytes, byteCount);
  }
  int writeNoGateway(const char * bytes, int byteCount) const {
    return ::send(fileDescriptor(), bytes, byteCount, MSG_DONTROUTE);
  }
protected:
  void setBuffer(DynamicBuffer * buffer) {_buffer=buffer;}
private:
  Address _peer;
  DynamicBuffer * _buffer;
};

} // namespace GpCoreTools

#endif // TCPCLIENTSTREAM_H
