/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-19
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TCPSERVERSTREAM_H
#define TCPSERVERSTREAM_H

#include <list>
#include <poll.h>

#include "Stream.h"
#include "Address.h"
#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class TcpClientStream;

class GPCORETOOLS_EXPORT TcpServerStream : public Stream
{
public:
  TcpServerStream();

  bool listen(uint16_t port, int maxConnections);

  virtual short eventTypes() {return POLLIN;}
  virtual void event(short type);

  void send(const char * bytes, int byteCount);
protected:
  virtual void childDeleted(Stream * client);
  virtual TcpClientStream * createClientStream(int fileDescriptor, const Address& peer)=0;
private:
  std::list<TcpClientStream *> _clients;
};

} // namespace GpCoreTools

#endif // TCPSERVERSTREAM_H
