/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-20
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMER_H
#define TIMER_H

#include <time.h>

#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT Timer
{
public:
  Timer();
  virtual ~Timer();

  void start();
  void stop();

  bool isRunning() {return _queued;}

  int interval() const {return _interval;}
  void setInterval(int i) {_interval=i;}

  void setTimeout();
  int timeout() const;
  bool after(Timer * o) const;

  void printDebug();

  virtual bool exec()=0;
private:
  friend class EventLoop;

  int _interval;
  timespec _timeout;

  class QueueItem
  {
  public:
    QueueItem(Timer * t) {_timer=t;}
    ~QueueItem() {if(_timer) _timer->stop();}

    Timer * timer() {return _timer;}
    void detach() {_timer=0;}
  private:
    Timer * _timer;
  };
  QueueItem * _queued;
};

} // namespace GpCoreTools

#endif // TIMER_H
