/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-12-26
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TRACE_H
#define TRACE_H

#include <vector>

#include "GpCoreToolsDLLExport.h"
#include "TraceStamp.h"

namespace GpCoreTools {

// Uncomment next line to get a backtrace in case of crash
#define TRACE_ENABLED

#ifdef TRACE_ENABLED

#define TRACE \
  static TraceStamp _traceStamp_(__PRETTY_FUNCTION__, __LINE__); \
  Trace _trace_0( &_traceStamp_ );

// Better to use ##__COUNTER__ macro but not working with gcc 4.1.3, maybe gcc 4.3
#define TRACE_N(index) \
  static TraceStamp _traceStamp_##index(__PRETTY_FUNCTION__, __LINE__); \
  Trace _trace_##index( &_traceStamp_##index );

class GPCORETOOLS_EXPORT Trace
{
public:
  Trace( const TraceStamp * stamp );
  ~Trace();

  static std::vector<const TraceStamp *> * mainStack() { return &_mainStack; }
  static std::string backTrace(const std::vector<const TraceStamp *> * stack);
private:
  std::vector<const TraceStamp *> * _myStack;
  static std::vector<const TraceStamp *> _mainStack;
};

#else
#define TRACE
#endif

} // namespace GpCoreTools

#endif // TRACE_H
