/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-10-20
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TRACEBUG_H
#define TRACEBUG_H

#include <vector>
#include <list>

#include "Variant.h"
#include "GpCoreToolsDLLExport.h"
#include "TraceInfo.h"

namespace GpCoreTools {

#define TRACE_BUG \
  static TraceStamp _traceBugStamp_(__PRETTY_FUNCTION__, __LINE__); \
  TraceBug _traceBug_0( &_traceBugStamp_ ); \
  TraceBug * _traceBug_ = &_traceBug_0;

// Better to use ##__COUNTER__ macro but not working with gcc 4.1.3, maybe gcc 4.3
#define TRACE_BUG_N(index) \
  static TraceStamp _traceBugStamp_##index(__PRETTY_FUNCTION__, __LINE__); \
  TraceBug _traceBug_##index( &_traceBugStamp_##index ); \
  _traceBug_ = &_traceBug_##index;

#define TRACE_POINTER(val) \
  _traceBug_->append( # val,val );

#define TRACE_INT(val) \
  _traceBug_->append( # val,val );

#define TRACE_BOOL(val) \
  _traceBug_->append( # val,val );

#define TRACE_DOUBLE(val) \
  _traceBug_->append( # val,val );

#define TRACE_STRING(val) \
  _traceBug_->append( # val,val );

class TraceStamp;

class GPCORETOOLS_EXPORT TraceBug
{
public:
  TraceBug( const TraceStamp * stamp );
  ~TraceBug();

  inline void append( const char * valName, const void * val );
  inline void append( const char * valName, Variant val );

  static std::vector<TraceBug *> * mainStack() { return &_mainStack; }
  static std::string backTrace(const std::vector<TraceBug *> * stack);
private:
  std::string toString() const;

  std::vector<TraceBug *> * _myStack;
  static std::vector<TraceBug *> _mainStack;

  const TraceStamp * _stamp;
  std::list<TraceInfo> _infos;
};

inline void TraceBug::append( const char * valName, const void * val )
{
  _infos.push_back(TraceInfo( valName, val ) );
}

inline void TraceBug::append( const char * valName, Variant val )
{
  _infos.push_back(TraceInfo( valName, val ) );
}

} // namespace GpCoreTools

#endif // TRACEBUG_H
