/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-10-20
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TRACEINFO_H
#define TRACEINFO_H

#include <string>

#include "GpCoreToolsDLLExport.h"
#include "Variant.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT TraceInfo
{
public:
  inline TraceInfo( const char * valName, const void * val );
  inline TraceInfo( const char * valName, Variant val );

  std::string toString() const;
private:
  const char * _valName;
  Variant _val;
};

inline TraceInfo::TraceInfo( const char * valName, const void * val )
{
  _valName = valName;
  _val = val;
}

inline TraceInfo::TraceInfo( const char * valName, Variant val )
{
  _valName = valName;
  _val = val;
}

} // namespace GpCoreTools

#endif // TRACEINFO_H
