/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2010-02-02
**  Authors:

**
***************************************************************************/

#ifndef UNIXCLIENTSTREAM_H
#define UNIXCLIENTSTREAM_H

#include <sys/un.h>
#include <poll.h>

#include "Stream.h"
#include "DynamicBuffer.h"
#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT UnixClientStream : public Stream
{
public:
  UnixClientStream(int fileDescriptor, const char * peer);
  UnixClientStream(const char * peer);
  virtual ~UnixClientStream();

  virtual bool connect();

  virtual short eventTypes() {return POLLIN | POLLRDHUP;}
  virtual void event(short type);
  virtual void hungup() {}

  DynamicBuffer * buffer() const {return _buffer;}

  int write(const char * bytes, int byteCount) const {
    return ::write(fileDescriptor(), bytes, byteCount);
  }

  static void setAddress(sockaddr_un& addr, const char * peer);
protected:
  void setBuffer(DynamicBuffer * buffer) {_buffer=buffer;}
private:
  sockaddr_un _peer;
  DynamicBuffer * _buffer;
};

} // namespace GpCoreTools

#endif // UNIXCLIENTSTREAM_H
