/***************************************************************************
**
**  This file is part of GpCoreTools.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-12-02
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef VARIANT_H
#define VARIANT_H

#include <string>

#include "GpCoreToolsDLLExport.h"

namespace GpCoreTools {

class GPCORETOOLS_EXPORT Variant
{
public:
  inline Variant();
  inline Variant(std::string& s);
  inline Variant(const char * s);
  inline Variant(int v);
  inline Variant(long v);
  inline Variant(const void * p);
  inline Variant(double v);
  Variant(const Variant& o);
  ~Variant();

  void operator=(const Variant& o);
  bool isValid() const {return _data;}
  std::string toString() const;
private:
  inline void assignInternal(const Variant& o);
  inline void clearInternal();

  enum Type {Unknown, String, Int, Long, Double};

  void * _data;
  Type _type;
};

inline Variant::Variant()
{
  _type=Unknown;
  _data=0;
}

inline Variant::Variant(std::string& s)
{
  _type=String;
  _data=new std::string(s);
}

inline Variant::Variant(const char * s)
{
  _type=String;
  _data=new std::string(s);
}

inline Variant::Variant(int v)
{
  _type=Int;
  _data=new int(v);
}

inline Variant::Variant(long v)
{
  _type=Long;
  _data=new long(v);
}

inline Variant::Variant(const void * p)
{
  _type=Long;
  _data=new long((long)p);
}

inline Variant::Variant(double v)
{
  _type=Double;
  _data=new double(v);
}

} // namespace GpCoreTools

#endif // VARIANT_H
