/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-08-23
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTSUMMARY_H
#define ABSTRACTSUMMARY_H

#include <SciFigs.h>

#include "MonoStationDLLExport.h"
#include "StationLine.h"

namespace MonoStation {

class AbstractStation;
class StationResults;
class SummaryMapOptions;

class MONOSTATION_EXPORT AbstractSummary : public GraphicSheetMenu
{
  Q_OBJECT
public:
  AbstractSummary(QWidget* parent=0);
  ~AbstractSummary();

  virtual void setWindowTitle(QString subPoolName) = 0;
  virtual void addActions();
  virtual void setStations(const QList<AbstractStation *>& stations);
  QMenu * menuTools;
public slots:
  virtual void setLimits();
private slots:
  void pickGridMaxima(bool on);
  void autoPickGridMaximum();
  void gridCrossSection();
  void mapOptions();
  void setMapOptions();
protected:
  QMap<double, StationResults *> distance2Station();

  virtual void createGraphs(bool multiStations)=0;
  void createStackedGraph(QString yAxisTitle, double x, double y);
  void createAverageGraph(QString yAxisTitle, double x, double y);
  void createSpectrumGridGraph(double x, double y);
  void createGridCrossSectionGraph(double x, double y);
  void createBubbleGraph(QString colorScaleTitle, double x, double y);

  virtual void setValues(const QMap<double, StationResults *> * dist2stat=0)=0;
  void setStackedValues();
  void setAverageValues();
  void setSpectrumGridValues(const QMap<double, StationResults *> * dist2stat);
  void setBubbleValues();

  LineLayer * stackedLayer() const {return _stackedLayer;}
  LineLayer * averageLayer() const {return _averageLayer;}
  IrregularGrid2DPlot * spectrumGridLayer() const {return _spectrumGridLayer;}
  GridMaxFollower * spectrumGridMaxLayer() const {return _spectrumGridMaxLayer;}
  LineLayer * gridCrossSectionLayer() const {return _gridCrossSectionLayer;}
  XYValuePlot * bubbleLayer() const {return _bubbleLayer;}
  NameLineLayer * bubbleNameLayer() const {return _bubbleNameLayer;}
private:
  LineLayer * _stackedLayer;
  LineLayer * _averageLayer;
  ParallelBands * _averagePeakLayer;
  IrregularGrid2DPlot * _spectrumGridLayer;
  GridMaxFollower * _spectrumGridMaxLayer;
  LineLayer * _gridCrossSectionLayer;
  XYValuePlot * _bubbleLayer;
  NameLineLayer * _bubbleNameLayer;

  QList<StationResults *> _stations;
  // Options
  StationLine::Label _mapLabels;
  StationLine::ValueType _mapValues;
  int _mapPeakValueDecimals;
  int _mapPeakIndex;
  bool _mapShowBubbles;
  Legend _categories;

  SummaryMapOptions * _mapOptions;
};

} // namespace MonoStation

#endif // ABSTRACTSUMMARY_H
