/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-08-17
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTTOOL_H
#define ABSTRACTTOOL_H

#include <GeopsyCore.h>
#include <GeopsyGui.h>

#include "MonoStationDLLExport.h"

namespace MonoStation {

class AbstractStation;
class AbstractToold;
class WinResults;
class AbstractSummary;

#define _winResults static_cast<WinResults*>(_childrenList[0])
#define _summary static_cast<AbstractSummary*>(_childrenList[1])

class MONOSTATION_EXPORT AbstractTool : public ToolBase
{
  Q_OBJECT
public:
  AbstractTool(QWidget * parent);
  ~AbstractTool();

  virtual void restoreFields();
  virtual void setParameters( int& argc, char ** argv );
  virtual void outputResults( int& argc, char ** argv);
  virtual void refreshSignal( Signal * sig );
protected slots:
  void signalMousePressed(bool& accept, QMouseEvent * e, int iSig, QRect * trackingRect);
  void signalMouseReleased(bool& accept, QMouseEvent * e);
  void signalMouseMoved(QPoint pt);
  void paintWindowPick( QPainter& p, double, int, int );
  void setCurrentDisplayStation();
  void updateNofWindows();
  void updateSummary();
  void forceReprocess();
  virtual void start();

  void autoWindows();
  void toggleAddWindows();
  void addWindows(AbstractStation * stat, const TimeRange& r);
  void toggleRemoveWindows();
  void removeWindows(AbstractStation * stat, const TimeRange& r);
  void inverseWindows();
  void clearWindows();
  void loadWindows(QString fileName = QString::null);
protected:
  void createResults( QString subPoolName );
  virtual void updateAllFields();
  virtual bool setLogParameters(QString& keyword, QString& value);
  virtual QString logParameters() const;
  virtual WinResults * createWinResults() = 0;
  virtual AbstractSummary * createSummary() = 0;
  virtual void setLimits();
  AbstractStation * belongsTo(Signal * sig);
  void windowsChanged();
  void setLog(AbstractStation * stat);
protected:
  StationList _stationSignals;
  QList <AbstractStation *> _stations;
  AbstractToold * _d;
private:
  QList<AbstractStation *> selectedStations();
  SparseKeepSignal * globalKeep(const TimeRange& r, const WindowingParameters& param);
  double deltaT();
  bool hasWindows();

  bool _forceReProcessAll;
  QRect * _trackingRect;
  Signal * _trackedSignal;
  QAction * _addWindowsAction, * _removeWindowsAction;
};

} // namespace MonoStation

#endif // ABSTRACTTOOL_H
