/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-29
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PEAKEDITOR_H
#define PEAKEDITOR_H

#include "AbstractStation.h"
#include "ui_PeakEditor.h"
#include "MonoStationDLLExport.h"

namespace MonoStation {

  class MONOSTATION_EXPORT PeakEditor : public QWidget, private Ui::PeakEditor
  {
    Q_OBJECT
  public:
    PeakEditor(QWidget * parent=0);
    ~PeakEditor();

    void setStations(QList<AbstractStation *> stations);
  private slots:
    void on_addButton_clicked();
    void on_adjustButton_clicked();
    void on_removeButton_clicked();
    void on_saveButton_clicked();
  signals:
    void touched();
  };

} // namespace MonoStation

#endif // PEAKEDITOR_H
