/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-29
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PEAKITEMMODEL_H
#define PEAKITEMMODEL_H

#include "AbstractStation.h"
#include "MonoStationDLLExport.h"

namespace MonoStation {

  class MONOSTATION_EXPORT PeakItemModel : public QAbstractTableModel
  {
  public:
    PeakItemModel(const QList<AbstractStation *>& stations, QObject * parent=0);
    ~PeakItemModel();

    const QList<AbstractStation *>& stations() const {return _stations;}
    StationResults * stationResults(int index);
    int peakIndex(int index);
    void adjust(int index, double min, double max);
    void remove(int index);
    void reset();

    virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
    virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
    virtual QVariant data(const QModelIndex &index, int role) const;
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
    virtual Qt::ItemFlags flags ( const QModelIndex & index ) const;
  private:
    QList<AbstractStation *> _stations;
    struct Peak
    {
      StationResults * _results;
      int _index;
    };
    QList<Peak *> _peaks;
  };

} // namespace MonoStation

#endif // PEAKITEMMODEL_H
