/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-10-10
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PEAKSEARCHRANGE_H
#define PEAKSEARCHRANGE_H

#include <QGpGuiTools.h>

#include "ui_PeakSearchRange.h"
#include "MonoStationDLLExport.h"

namespace MonoStation {

  class MONOSTATION_EXPORT PeakSearchRange : public Dialog, private Ui::PeakSearchRange
  {
    Q_OBJECT
  public:
    PeakSearchRange(QWidget* parent=0, Qt::WFlags fl=0);

    double minimum() const {return fromFrequency->value();}
    double maximum() const {return toFrequency->value();}
  };

} // namespace MonoStation

#endif // PEAKSEARCHRANGE_H
