/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-10-10
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REPLACELOG_H
#define REPLACELOG_H

#include <QGpGuiTools.h>
#include "ui_ReplaceLog.h"
#include "MonoStationDLLExport.h"

namespace MonoStation {

class MONOSTATION_EXPORT ReplaceLog : public Dialog, public Ui::ReplaceLog
{
  Q_OBJECT

public:
  ReplaceLog( QWidget* parent = 0, Qt::WFlags fl = 0 );
  ~ReplaceLog();

  virtual bool isReplaceAll();
  virtual bool isYes();
  virtual bool isNo();
  virtual bool isCancel();
  virtual bool isRename();

public slots:
  virtual void setStatName( QString statName );
  virtual void buttonYes_clicked();
  virtual void buttonNo_clicked();
  virtual void buttonCancel_clicked();
  virtual void buttonRename_clicked();

protected:
  short _result;

};

} // namespace MonoStation

#endif // REPLACELOG_H
