/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-03-29
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SETCATEGORY_H
#define SETCATEGORY_H

#include <QGpGuiTools.h>
#include "ui_SetCategory.h"
#include "MonoStationDLLExport.h"

namespace MonoStation {

class MONOSTATION_EXPORT SetCategory : public Dialog, private Ui::SetCategory
{
  Q_OBJECT
public:
  SetCategory( QWidget * parent=0 );

  void setCategoryNames( const QStringList& names );

  void setCurrentCategory( const QString& name ) { categoryNameEdit->setEditText( name ); }
  QString currentCategory() const { return categoryNameEdit->currentText(); }
};

} // namespace MonoStation

#endif // SETCATEGORY_H
