/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-03-04
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPECTRUMPARAMETERS_H
#define SPECTRUMPARAMETERS_H

#include <GeopsyCore.h>
#include <QGpCoreTools.h>

#include "MonoStationDLLExport.h"

namespace MonoStation {

class AbstractToold;

class MONOSTATION_EXPORT SpectrumParameters : public AbstractParameters
{
public:
  SpectrumParameters();
  ~SpectrumParameters();

  enum HorizontalType { Energy, Azimuth, Squared };
  // Functions to set parameters
  void setTaperWidthRatio(double wr) {_taperWidth=wr;}
  void setFromDialog(AbstractToold * d);
  // Functions to get parameters
  bool doTaper() {return _taperWidth>0;}
  double taperWidthRatio() {return _taperWidth;}
  QDir * outputDirectory() const { return _outputDirectory; }
  HorizontalType horizontalType() const { return _horizontal; }
  double horizontalAzimuth() const { return _horizontalAzimuth;}
public:
  Sampling sampling;
  SmoothingParameters smoothing;
  QString makeUpResults;
  QString makeUpSummary;
  int nPlotsPerLineResults;
  double pageHeightResults;
  bool computeAverage;
  double highPassFrequency;
protected:
  QDir * _outputDirectory;
  double _taperWidth;
  HorizontalType _horizontal;
  double _horizontalAzimuth;
};

} // namespace MonoStation

#endif // SPECTRUMPARAMETERS_H
