/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2010-01-27
**  Authors:

**
***************************************************************************/

#ifndef STATIONLINE_H
#define STATIONLINE_H

#include <SciFigs.h>

#include "MonoStationDLLExport.h"
#include "StationResults.h"

namespace MonoStation {

class MONOSTATION_EXPORT StationLine : public AbstractNameLine
{
public:
  virtual AbstractLine * clone() const;
  void operator=(const StationLine& o);

  virtual const QString& xml_tagName() const {return NameLine::xmlNameLineTag;}

  virtual int count() const {return 1;}
  virtual Point point(int) const {return _station->coordinates();}
  virtual QString name(int) const;

  virtual void clear() {}
  virtual void append() {}
  virtual void insert(int) {}
  virtual void removeLast() {}
  virtual void setX(int, double) {}
  virtual void setY(int, double) {}
  virtual void setZ(int, double) {}
  virtual void setName(int, QString) {}

  enum Label {StationName, PeakValue, NoLabel};
  enum ValueType {PeakNumber, PeakLowest, PeakHighest, PeakMaximum};

  void setStation(StationResults * station) {_station=station;}
  void setLabel(Label l) {_label=l;}
  void setLabelPrecision(int p) {_labelPrecision=p;}
  void setValue(ValueType v, int peakIndex);
  const Value& value() const {return _value;}
protected:
  Label _label;
  int _labelPrecision;
  Value _value;
  StationResults * _station;
};

} // namespace MonoStation

#endif // STATIONLINE_H
