/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-12-12
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATISTICRESULTS_H
#define STATISTICRESULTS_H

#include <SciFigs.h>

namespace MonoStation {

  class StationResults;

  class StatisticResults : public GraphicSheetMenu
  {
  public:
    StatisticResults(QWidget* parent=0);
    ~StatisticResults();

    void createObjects(QStringList& graphTitles);
    void setStatPlot(int graphIndex);
    void setStatPlot(int graphIndex,
                     const Curve<Point2D>& curve0,
                     const Curve<Point2D>& curve1,
                     const Curve<Point2D>& curve2);
    inline ParallelBands * frequencyLayer( int graphIndex ) const;
    inline LineLayer * averageLayer( int graphIndex ) const;

    void setBandsPlot( int graphIndex, ParallelBands * b );
    void setWindowTitle(QString t);

    static void studentTest(const StationResults * ref, const StationResults * other, double significance,
                            const QString& makeUp=QString::null);
  protected:
    virtual void closeEvent (QCloseEvent * e);
  private:
    QVector<ParallelBands *> _frequencyLayers;
    QVector<LineLayer *> _averageLayers;
  };

  inline ParallelBands * StatisticResults::frequencyLayer( int graphIndex ) const
  {
    TRACE;
    return _frequencyLayers.at(graphIndex);
  }

  inline LineLayer * StatisticResults::averageLayer( int graphIndex ) const
  {
    TRACE;
    return _averageLayers.at(graphIndex);
  }

} // namespace MonoStation

#endif
