/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-10-10
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STUDENTTEST_H
#define STUDENTTEST_H

#include <QGpGuiTools.h>

#include "WinResults.h"
#include "ui_StudentTest.h"

namespace MonoStation {

  class StudentTest: public Dialog, private Ui::StudentTest
  {
    Q_OBJECT
  public:
    StudentTest(QWidget* parent=0, Qt::WFlags fl=0);

    void init(QList<WinResults *> & tests);

    StationResults * firstCurve() const;
    StationResults * secondCurve() const;
    double significance() const {return significanceEdit->value();}
    QString makeUp() const {return makeUpFile->text();}
  private slots:
    void on_makeUpBrowse_clicked();
  };

} // namespace MonoStation

#endif // STUDENTTEST_H
